﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.StressInput;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using System.Xml.Serialization;
using System.Xml;
using System.Runtime.Serialization;
using System.IO;

namespace BMS.StressGenerator
{
    class Program
    {
        static Input input = new Input();
        static Input inputForUpdate = null;
        static List<Admission> listAdm = new List<Admission>();
        static ConnectionStringSettingsCollection connections = ConfigurationManager.ConnectionStrings;
        static SqlCommand cmd = null;

        static CDList waitingAreaList = new CDList();
        static CDList dispositionList = new CDList();
        static CDList contractList = new CDList();
        static CDList authorizationList = new CDList();
        static CDList serviceReceiveList = new CDList();
        static CDList reasonUsingFeeList = new CDList();
        static CDList genderList = new CDList();

        static Random rnd = new Random();
        static DataTable dtPatients;
        const int nbPatientsReq = 50;

        static List<Transfer> listTransfer = new List<Transfer>();

        enum Methods
        {
            CreateTransferRequest,
            UpdateTransferRequest,
            CreateTransferEvent
        }

        static void Serialize(string filename)
        {
            using (FileStream writer = new FileStream(filename, FileMode.Create, FileAccess.Write))
            {
                DataContractSerializer ser = new DataContractSerializer(typeof(Input));
                ser.WriteObject(writer, input);
            }
        }

        static void Deserialize(string filename)
        {
            using (FileStream reader = new FileStream(filename, FileMode.Open, FileAccess.Read))
            {
                DataContractSerializer ser = new DataContractSerializer(typeof(Input));
                inputForUpdate = (Input)ser.ReadObject(reader);
            }
        }

        static void Main(string[] args)
        {
            ReadConfigData();

            if (input.WorkflowName.ToUpper() == "ADMISSION")
            {
                CreateAdmissions();
                input.AdmissionList = listAdm;

                //serialize object
               Serialize("c:/Admission.xml");

                Console.WriteLine("Admission succeeded.");
                Console.ReadKey();
            }
            else
                if (input.WorkflowName.ToUpper() == "TRANSFER")
                {
                    CreateTransfer();
                    input.TransferList = listTransfer;

                    //serialize object
                    Serialize("c:/Transfer.xml");

                    Console.WriteLine("Transfer succeeded.");
                    Console.ReadKey();
                }
        }

        private static void CreateTransfer()
        {
            int randomIndex = -1, i = 1;
            II transferId = null;
            string[] Diagnostics = new string[] { "Tonsilitis", "Leukemia", "Gl bleed", "Headache" };
            string[] CurrLocation = new string[] { "Jewish", "Sweedish", "Danish", "Spanish" };
            string[] Comment = new string[] { "Med/telemetry", "Need for care", "Need for sleep" };

            genderList = GetVocabularies("2.16.840.1.113883.5.1", "Gender");

            DateTime start = new DateTime(2011, 11, 01);
            DateTime end = new DateTime(2011, 11, 15);
            DateTime dtTransferRequest = RandomDay(start, end);

            IList<Facility> listFacility = BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.GetFacilitiesUsingWindowsAuthentication();
            IList<Region> listRegion = BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.GetRegions();
            
            List<Visn> listVisn = new List<Visn>();
            IList<Visn> listVisn1 = null;

            foreach (Region reg in listRegion)
            {
                listVisn1 = BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.GetVisns(reg.Id);
                foreach (Visn visn in listVisn1)
                    visn.Region = reg;
                listVisn.AddRange(listVisn1);
            }

            foreach (Facility fac in listFacility)
            {
                fac.Visn = listVisn.Where(a => a.Id.extension == fac.Visn.Id.extension).FirstOrDefault();
            }

            //set inputForUpdate object
            if (input.MethodName != Methods.CreateTransferRequest.ToString())
                Deserialize("c:/Transfer.xml");

            while (i > 0)
            {
                i = GetPatients(i, nbPatientsReq);

                foreach (DataRow dtpt in dtPatients.Rows) //for each patient create a transfer
                {
                    Patient pt = new Patient();
                    pt.Id = new II("InfoWorld", dtpt["UID"].ToString());
                    //pt.Ien = ?
                    pt.SSN = new II("InfoWorld", dtpt["SSN"].ToString());
                    pt.FirstName = dtpt["FIRST_NAME"].ToString();
                    pt.LastName = dtpt["LAST_NAME"].ToString();
                    pt.MiddleName = dtpt["MIDDLE_INITIAL"].ToString();
                    pt.Gender = genderList.Where(a => a.code == dtpt["CODE"].ToString()).FirstOrDefault();


                    if (input.MethodName == Methods.UpdateTransferRequest.ToString() || input.MethodName == Methods.CreateTransferEvent.ToString())
                    {
                        //get the transfer id for the current patient
                        Transfer trsf = inputForUpdate.TransferList.Where(t => t.Patient.Id.extension == pt.Id.extension).FirstOrDefault();
                        transferId = trsf.Id;
                    }
                    else
                        if (input.MethodName == Methods.CreateTransferRequest.ToString())
                            transferId = new II("InfoWorld", null);

                    if (input.MethodName == Methods.UpdateTransferRequest.ToString() || input.MethodName == Methods.CreateTransferRequest.ToString())
                    {
                        //get vocabs for transfer
                        CDList eraList = GetVocabularies("2.12.24.41", "Era");
                        CDList vistaSpecialtyList = GetVocabularies("2.12.24.39", "VistaSpecialty");
                        contractList = GetVocabularies("2.12.24.15", "StrictDecision");


                        Transfer transfer = new Transfer()
                        {
                            Id = transferId,
                            Patient = pt,

                            CreationDate = dtTransferRequest,
                            AdmissionDate = dtTransferRequest,
                            CanceledDate = null,

                            FacilityFrom = listFacility[rnd.Next(listFacility.Count)],
                            SCRating = rnd.Next(100).ToString(),

                            Diagnosis = Diagnostics[rnd.Next(Diagnostics.Length)],
                            CurrentLocation = CurrLocation[rnd.Next(CurrLocation.Length)],
                            Comment = Comment[rnd.Next(Comment.Length)],

                            Edited = DateTime.UtcNow,
                            EnteredBy = System.Environment.UserName,
                            LastEditBy = System.Environment.UserName

                        };

                        randomIndex = rnd.Next(eraList.Count);
                        transfer.Era = eraList[randomIndex];

                        randomIndex = rnd.Next(contractList.Count);
                        transfer.Contract = contractList[randomIndex];

                        randomIndex = rnd.Next(vistaSpecialtyList.Count);
                        transfer.Speciality = vistaSpecialtyList[randomIndex];

                        listTransfer.Add(transfer);
                    }
                    else
                        if (input.MethodName == Methods.CreateTransferEvent.ToString())
                        {
                            CDList dispositionList = GetVocabularies("2.12.24.29", "Disposition");
                            start = new DateTime(2011, 11, 16);
                            end = new DateTime(2011, 11, 20);
                            DateTime dtTransferEvent = RandomDay(start, end);

                            Transfer transfer = new Transfer()
                            {
                                Id = new II("InfoWorld", null),
                                Parent = new Act() { Id = transferId },

                                CreationDate = dtTransferEvent,
                                DispositionDate = dtTransferEvent,

                                CanceledDate = null,
                                Patient = pt,
                                Disposition = dispositionList[rnd.Next(dispositionList.Count)],
                                FacilityTo = listFacility[rnd.Next(listFacility.Count)],
                                
                                DischargeComment = null,
                                Edited = DateTime.UtcNow,
                                EnteredBy = System.Environment.UserName,
                                LastEditBy = System.Environment.UserName

                            };

                            listTransfer.Add(transfer);
                        }
                    
                }
            }
        }

        public static void ReadConfigData()
        {
            input.WorkflowName = System.Configuration.ConfigurationManager.AppSettings["Workflow"];
            input.MethodName = System.Configuration.ConfigurationManager.AppSettings["Method"];
        }

        public static DateTime RandomDay(DateTime startDay, DateTime endDay)
        {
            Random gen = new Random();

            int range = ((TimeSpan)(endDay - startDay)).Days;
            return startDay.AddDays(gen.Next(range));
        }

        private static int GetPatients(int nxtPage, int nbRows)
        {
            SqlParameter[] coll = {
                                    new SqlParameter("@nextPage", nxtPage) {Direction = ParameterDirection.InputOutput},
                                    new SqlParameter("@rowsPerPage", nbRows) 
                                  };

            dtPatients = RunStoredProc("BMS", "usp_Get_Patients", coll).Tables[0];

            return int.Parse(coll[0].Value.ToString());
        }


        public static void CreateAdmissions()
        {
            int randomIndex = -1, i = 1;
            string[] Problem = new string[] { "Chest pain", "Hand pain", "Leg pain", "Digestion problem" };
            string[] TypeOfBed = new string[] { "test1", "test2", "test3" };
            string[] CommentFee = new string[] { "test1.1", "test1.2", "test1.3" };

            DateTime start = new DateTime(2011, 09, 01);
            DateTime end = new DateTime(2011, 10, 17);
            DateTime dtAdmissionRequest = RandomDay(start, end);

            genderList = GetVocabularies("2.16.840.1.113883.5.1", "Gender");
            
            SelectVocabularies();

            //end when there are no more patients in the db
            while(i > 0)
            {
                i = GetPatients(i, nbPatientsReq);
            
                foreach(DataRow dtpt in dtPatients.Rows) //for each patient create an admission
                {
                    Patient pt = new Patient();
                    pt.Id = new II("InfoWorld", dtpt["UID"].ToString());
                    //pt.Ien = ?
                    pt.SSN = new II("InfoWorld", dtpt["SSN"].ToString());
                    pt.FirstName = dtpt["FIRST_NAME"].ToString();
                    pt.LastName = dtpt["LAST_NAME"].ToString();
                    pt.MiddleName = dtpt["MIDDLE_INITIAL"].ToString();
                    pt.Gender = genderList.Where(a => a.code == dtpt["CODE"].ToString()).FirstOrDefault();

                    Admission admission = new Admission()
                    {
                        Id = new II("InfoWorld", null),
                        Patient = pt,
                        CreationDate = dtAdmissionRequest,
                        RequestedDate = dtAdmissionRequest,
                        SignedDate = dtAdmissionRequest,
                        Problem = Problem[rnd.Next(Problem.Length)],
                        TypeOfBedWard = TypeOfBed[rnd.Next(TypeOfBed.Length)],
                        CommentFee = CommentFee[rnd.Next(CommentFee.Length)],
                   
                        BedAssignedDateTime = null,
                        AssignedBed = null
                    };

                    randomIndex = rnd.Next(waitingAreaList.Count);
                    admission.WaitingArea = waitingAreaList[randomIndex];

                    randomIndex = rnd.Next(dispositionList.Count);
                    admission.Disposition = dispositionList[randomIndex];

                    randomIndex = rnd.Next(contractList.Count);
                    admission.Contract = contractList[randomIndex];

                    randomIndex = rnd.Next(authorizationList.Count);
                    admission.Authorization = authorizationList[randomIndex];

                    randomIndex = rnd.Next(serviceReceiveList.Count);
                    admission.ServiceReceive = serviceReceiveList[randomIndex];

                    randomIndex = rnd.Next(reasonUsingFeeList.Count);
                    admission.ReasonFee = reasonUsingFeeList[randomIndex];

                    admission.IsAddedToWaitingList = true;
                    admission.Facility = null;

                    listAdm.Add(admission);
      
                }
            }
        }

        private static void SelectVocabularies()
        {
            waitingAreaList = GetVocabularies("2.12.24.8", "WaitingArea");
            dispositionList = GetVocabularies("2.12.24.23", "FeeDisposition");
            contractList = GetVocabularies("2.12.24.15", "StrictDecision");
            authorizationList = GetVocabularies("2.12.24.15", "StrictDecision");

            serviceReceiveList = GetVocabularies("2.12.24.24", "ServicesReceiving");
            reasonUsingFeeList = GetVocabularies("2.12.24.25", "FeeReason");
            
            GetVocabularies("2.12.24.28", "PTRiskFlags");
        }

        private static CDList GetVocabularies(string vocDomainName, string codeSystemName)
        {
            CDList cdlist = new CDList();

            SqlParameter[] coll = {
                new SqlParameter("@vocabulary_domain_Name", vocDomainName),
                new SqlParameter("@context", DBNull.Value),
                new SqlParameter("@is_value_set", 1),
                new SqlParameter("@size_limit", 101),
                new SqlParameter("@max_level", 1),
                new SqlParameter("@language_code", "en"),
                new SqlParameter("@min_PK", -1)
            };

            DataSet dsWaitArea = RunStoredProc("EVS", "GET_VALUE_SET_EXPANSION_from_FROM_NESTEDT_WP", coll);

            CD aCD;

            DataTable dt = dsWaitArea.Tables[dsWaitArea.Tables.Count - 1];
            foreach (DataRow row in dt.Rows)
            {
                aCD = new CD(row["concept_code"].ToString(), row["code_system_ID"].ToString(), codeSystemName, "1", 
                            row["concept_designation"].ToString(), null, null, null);

                cdlist.Add(aCD);
            }

            return cdlist;

        }

        public static DataSet RunStoredProc(string connStrName, string spName, SqlParameter[] spParams)
        {
            SqlConnection conn = null;

            try
            {
                // create and open a connection object
                conn = new SqlConnection(connections[connStrName].ToString());
                conn.Open();

                cmd = new SqlCommand(spName, conn);
                cmd.CommandType = CommandType.StoredProcedure;

                foreach(SqlParameter par in spParams)
                    cmd.Parameters.Add(par);

                SqlDataAdapter mySqlDataAdapter = new SqlDataAdapter();
                mySqlDataAdapter.SelectCommand = cmd;
                DataSet myDataSet = new DataSet();
                                
                mySqlDataAdapter.Fill(myDataSet);

                return myDataSet;
            }
            finally
            {
                if (conn != null)
                {
                    conn.Close();
                }
                
            }
        }
    }
}
